﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CryptoCMP.Deposition;
using CryptoCMP.CAInteraction;
using CryptoCMP.Utils;
using CryptoCMP;

namespace DepositionCMP
{
    class Program
    {
        static void Main(string[] args)
        {

            DepositionRequest dep_req = new DepositionRequest();            
            byte[] dep_req_byte = dep_req.FormRequest("profile://OCSP_TEST", System.Text.Encoding.ASCII.GetBytes("vogonova001"), System.Text.Encoding.ASCII.GetBytes("1234567890"));
            SendRequest send = new SendRequest();
            int err = 0;
            byte[] resp3 = send.SendMessage(5, "192.168.10.30", "62295", dep_req_byte, ref err);



            VerifyCMPResponce ver = new VerifyCMPResponce();
            ver.profile = "profile://OCSP_TEST";
            ver.secret = "1234567890";
            ver.otp = dep_req.OTP;
            bool r = ver.Verify(resp3, CryptoCMP.CpTumar.PKI_CMP_GENP); 


            DepositionRequest dep_req_get_key = new DepositionRequest();
            byte[] getkey_byte = dep_req_get_key.GetKeysFromServer(System.Text.Encoding.ASCII.GetBytes(ver.TransactionID), System.Text.Encoding.ASCII.GetBytes("vogonova001"), System.Text.Encoding.ASCII.GetBytes("1234567890"));
            byte[] resp4 = send.SendMessage(5, "192.168.10.30", "62295", getkey_byte, ref err);

            ver.profile = "profile://USER_KISC";
            ver.secret = "1234567890";
            ver.otp = dep_req.OTP;
            r = ver.Verify(resp4, 100);

            DepositionRequest dep_del = new DepositionRequest();
            byte[] del_byte = dep_del.RemoveKeysFromServer(System.Text.Encoding.ASCII.GetBytes(ver.TransactionID), System.Text.Encoding.ASCII.GetBytes("vogonova001"), System.Text.Encoding.ASCII.GetBytes("1234567890"));
            byte[] resp5 = send.SendMessage(5, "192.168.10.30", "62295", del_byte, ref err);



            ver.profile = "profile://OCSP_TEST";
            ver.secret = "1234567890";
            ver.otp = dep_req.OTP;
            r = ver.Verify(resp5, CryptoCMP.CpTumar.PKI_CMP_GENP); 
        }
    }
}
